import pandas as pd

cities = pd.read_csv('cities.csv')
precip = pd.read_csv('precip.csv')

both = pd.merge(cities, precip, on=['city'])
# note, the merge automatically eliminates rows which aren't in both

# calculate monthly precip column
both['monthly precipitation'] = both['yearly precipitation'] / 12

# make dataframe with needed columns only
both = both[['city', 'state', 'population', 'monthly precipitation']]

both.to_csv('cityrain.csv', index=False)
