from multiprocessing import Process, SimpleQueue

# read in the dictionary as a single list
words = []
for line in open('english.txt'):
    words.append(line.strip())

# counts how many words (within the given range of indices)
# appear inside any other word in the list.
def count_subwords(start_ind, end_ind, queue):
    count = 0
    for word in words[start_ind: end_ind]:
        for other_word in words:
            if word == other_word:
                continue # skip the word itself
            if word in other_word:
                count += 1
                break
    queue.put(count)

if __name__ == '__main__':
    # each of 10 processes will get a sub-range
    nprocs = 10
    # you could also just hard-code (0,10000), (10000,20000), etc.
    splits = [int(len(words) * i / nprocs) for i in range(nprocs+1)]

    # create a single shared SimpleQueue for inter-process communication
    queue = SimpleQueue()

    # start the processes
    for i in range(nprocs):
        child = Process(target=count_subwords, args=[splits[i], splits[i+1], queue])
        child.start()

    # wait for the results and add up the counts
    total = 0
    for _ in range(nprocs):
        total += queue.get()

    print(total)
