# see p1-pandas.py for a better solution!

from csv import DictReader, DictWriter

# create dictionary of city name -> precipitation amount
precip = {}
for row in DictReader(open('precip.csv', newline='')):
    # note we need to use float() here or it would be a string
    precip[row['city']] = float(row['yearly precipitation'])

# now loop over rows in cities file and write (matching)
# rows to the output file

with open('cityrain.csv', 'w', newline='') as outf:
    out = DictWriter(outf, ['city', 'state', 'population', 'monthly precipitation'])
    out.writeheader()
    for row in DictReader(open('cities.csv', newline='')):
        try:
            cityprecip = precip[row['city']]
        except KeyError:
            # skip rows not in both input csvs
            continue
        outrow = {
            'city': row['city'],
            'state': row['state'],
            'population': row['population'],
            'monthly precipitation': cityprecip / 12,
        }
        out.writerow(outrow)
